IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_EST_PROD_TRANSF_IT_AUDIT' AND TYPE = 'TR')
BEGIN
	DROP TRIGGER dbo.TRG_EST_PROD_TRANSF_IT_AUDIT 
END
GO

GO 
CREATE TRIGGER [dbo].TRG_EST_PROD_TRANSF_IT_AUDIT ON [dbo].[EST_PROD_TRANSF_IT] 
AFTER INSERT, UPDATE 
AS

IF UPDATE(QT_SOL)
BEGIN         
	INSERT INTO EST_PROD_TRANSF_IT_AUDIT
						( CD_EMP , CD_FILIAL, CD_FIL_DEST, CD_CTR, TP_TRANSF, 
								CD_PROD, QT_SOL, VLR_CUSTO, DT_CAD, DT_CAD_AUDIT)
	SELECT F.CD_EMP
		, F.CD_FILIAL
		, F.CD_FIL_DEST
		, F.CD_CTR
		, F.TP_TRANSF
		, IT.CD_PROD
		, IT.QT_SOL
		, IT.VLR_CUSTO
		, F.DT_CAD
		, GETDATE()
	FROM
		EST_PROD_TRANSF F
		INNER JOIN INSERTED IT ON 
			F.CD_EMP	= IT.CD_EMP
		AND F.CD_FILIAL = IT.CD_FILIAL
		AND F.CD_CTR	= IT.CD_CTR
END 
